/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public abstract class SmartLanguageProvider
implements DataProvider {
    private final Map<String, String> data = new TreeMap<String, String>();
    private final PackOutput output;
    private final String modid;
    private final String locale;

    public SmartLanguageProvider(PackOutput output, String modid, String locale) {
        this.output = output;
        this.modid = modid;
        this.locale = locale;
    }

    protected abstract void addTranslations();

    protected abstract Iterable<Item> getKnownItems();

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addTranslations();
        for (Item item : this.getKnownItems()) {
            this.validateEntry(item.m_5524_(), ForgeRegistries.ITEMS.getKey((Object)item));
        }
        if (!this.data.isEmpty()) {
            return this.save(cache, this.output.m_247566_(PackOutput.Target.RESOURCE_PACK).resolve(this.modid).resolve("lang").resolve(this.locale + ".json"));
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public String m_6055_() {
        return "Languages: " + this.locale;
    }

    private void validateEntry(String langKey, @Nullable ResourceLocation name) {
        if (!this.data.containsKey(langKey)) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Missing lang entry for '%s'", name));
        }
    }

    private CompletableFuture<?> save(CachedOutput cache, Path target) {
        JsonObject json = new JsonObject();
        this.data.forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)target);
    }

    public void addBlock(Supplier<? extends Block> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Block key, String name) {
        this.add(key.m_7705_(), name);
    }

    public void addItem(Supplier<? extends Item> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Item key, String name) {
        this.add(key.m_5524_(), name);
    }

    public void addItemStack(Supplier<ItemStack> key, String name) {
        this.add(key.get(), name);
    }

    public void add(ItemStack key, String name) {
        this.add(key.m_41778_(), name);
    }

    public void addEnchantment(Supplier<? extends Enchantment> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Enchantment key, String name) {
        this.add(key.m_44704_(), name);
    }

    public void addEffect(Supplier<? extends MobEffect> key, String name) {
        this.add(key.get(), name);
    }

    public void add(MobEffect key, String name) {
        this.add(key.m_19481_(), name);
    }

    public void addEntityType(Supplier<? extends EntityType<?>> key, String name) {
        this.add(key.get(), name);
    }

    public void add(EntityType<?> key, String name) {
        this.add(key.m_20675_(), name);
    }

    public void add(String key, String value) {
        if (this.data.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }
}

